using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static double PovrsinaPoligona(List<(int, int)> tacke)
    {
        int n = tacke.Count;
        double povrsina = 0;
        for (int i = 0; i < n; i++)
        {
            int x1 = tacke[i].Item1, y1 = tacke[i].Item2;
            int x2 = tacke[(i + 1) % n].Item1, y2 = tacke[(i + 1) % n].Item2;
            povrsina += x1 * y2 - x2 * y1;
        }
        return Math.Abs(povrsina) / 2;
    }

    static List<(int, int)> KonveksniOmotac(List<(int, int)> tacke)
    {
        tacke = tacke.OrderBy(p => p.Item1).ThenBy(p => p.Item2).ToList();

        var donji = new List<(int, int)>();
        foreach (var p in tacke)
        {
            while (donji.Count >= 2 && PrekrseniProizvod(donji[donji.Count - 2], donji[donji.Count - 1], p) <= 0)
                donji.RemoveAt(donji.Count - 1);
            donji.Add(p);
        }

        var gornji = new List<(int, int)>();
        for (int i = tacke.Count - 1; i >= 0; i--)
        {
            while (gornji.Count >= 2 && PrekrseniProizvod(gornji[gornji.Count - 2], gornji[gornji.Count - 1], tacke[i]) <= 0)
                gornji.RemoveAt(gornji.Count - 1);
            gornji.Add(tacke[i]);
        }

        donji.RemoveAt(donji.Count - 1);
        gornji.RemoveAt(gornji.Count - 1);

        donji.AddRange(gornji);
        return donji;
    }

    static int PrekrseniProizvod((int, int) o, (int, int) a, (int, int) b)
    {
        return (a.Item1 - o.Item1) * (b.Item2 - o.Item2) - (a.Item2 - o.Item2) * (b.Item1 - o.Item1);
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var tacke = new List<(int, int)>();

        for (int i = 0; i < N; i++)
        {
            var koordinate = Console.ReadLine().Split();
            tacke.Add((int.Parse(koordinate[0]), int.Parse(koordinate[1])));
        }

        var omotac = KonveksniOmotac(tacke);

        double minimalnaPovrsina = double.MaxValue;

        for (int i = 0; i < N; i++)
        {
            var smanjeneTacke = new List<(int, int)>(tacke);
            smanjeneTacke.RemoveAt(i);

            var smanjenOmotac = KonveksniOmotac(smanjeneTacke);
            double povrsina = PovrsinaPoligona(smanjenOmotac);

            minimalnaPovrsina = Math.Min(minimalnaPovrsina, povrsina);
        }

        Console.WriteLine((long)minimalnaPovrsina);
    }
}